<?php
if (!defined("_GNUBOARD_")) exit; // 개별 페이지 접근 불가

global $member, $is_admin;

// 옵션 : 설문조사 번호
$wos = apms_options($options, $m_options);
$poll = apms_poll_rows($wos);

if(!$poll) {
	echo '<p class="text-muted text-center">등록된 설문이 없습니다.</p>'.PHP_EOL;	
	return;
}

?>

<section>
	<form class="form" role="form" name="fpoll" action="<?php echo G5_BBS_URL; ?>/poll_update.php" onsubmit="return fpoll_submit(this);" method="post">
	<input type="hidden" name="po_id" value="<?php echo $poll['po_id'] ?>">
		<div class="panel panel-default">
			<div class="panel-heading">
				<h3 class="panel-title"><?php echo $poll['po_subject'] ?></h3>
			</div>
			<div class="panel-body">
				<?php for ($i=1; $i<=9 && $poll["po_poll{$i}"]; $i++) {  ?>
					<div class="checkbox">
						<label><input type="radio" name="gb_poll" value="<?php echo $i ?>" id="gb_poll_<?php echo $i ?>"> <?php echo $poll['po_poll'.$i] ?></label>
					</div>
				<?php }  ?>

				<br>

				<div class="text-center">
					<div class="btn-group">
						<button type="submit" class="btn btn-color btn-sm">투표하기</button>
						<a href="<?php echo G5_BBS_URL;?>/poll_result.php?po_id=<?php echo $poll['po_id'];?>" target="_blank" onclick="poll_result(this.href); return false;" class="btn btn-black btn-sm">결과보기</a>
						<?php if ($is_admin == "super") {  ?>
							<a href="<?php echo G5_ADMIN_URL; ?>/poll_form.php?w=u&amp;po_id=<?php echo $poll['po_id']; ?>" class="btn btn-black btn-sm">관리</a>
						<?php }  ?>
					</div>
				</div>
			</div>
		</div>
	</form>
</section>

<script>
function fpoll_submit(f) {
    <?php
    if ($member['mb_level'] < $poll['po_level'])
        echo " alert('권한 {$po['po_level']} 이상의 회원만 투표에 참여하실 수 있습니다.'); return false; ";
     ?>

    var chk = false;
    for (i=0; i<f.gb_poll.length;i ++) {
        if (f.gb_poll[i].checked == true) {
            chk = f.gb_poll[i].value;
            break;
        }
    }

    if (!chk) {
        alert("투표하실 설문항목을 선택하세요");
        return false;
    }

    var new_win = window.open("about:blank", "win_poll", "width=616,height=500,scrollbars=yes,resizable=yes"); 
    f.target = "win_poll"; 

    return true;
}

function poll_result(url) {
    <?php
    if ($member['mb_level'] < $poll['po_level'])
        echo " alert('권한 {$poll['po_level']} 이상의 회원만 결과를 보실 수 있습니다.'); return false; ";
     ?>

    win_poll(url);
}
</script>
